"""I provide a source to read AMMOS data from a socket."""

import socket

from ammosreader.AmmosSource import AmmosSource
from ammosreader import logger


class AmmosSocketSource(AmmosSource):
    """I implement a descendent of AmmosSource that reads from a socket."""

    def read_bytes(self, bytes_to_read):
        byte_array = []

        try:
            while len(b''.join(byte_array)) < bytes_to_read:
                logger.info("Remaining Bytes: %s", bytes_to_read - len(b''.join(byte_array)))
                self.__source.settimeout(5)
                new_bytes = self.source.recv(bytes_to_read - len(b''.join(byte_array)), socket.MSG_WAITALL)

                if not new_bytes:
                    raise TimeoutError("Socket timed out while reading data")
                logger.info("Got %s bytes of %s remaining", len(new_bytes), bytes_to_read - len(b''.join(byte_array)))
                byte_array.append(new_bytes)
        except TimeoutError:
            return None
        return b''.join(byte_array)
