# AmmosReader

Project containing necessary File- or SocketStream-Reader to read the
various datastreams of Ammos

# Installation

## Standard pip install (not tested on all platforms)

``` shell
git clone http://gitlab.kid.local/kidzg/ammosreader.git
cd ammosreader
python3 -m pip install .
```

## Using the guix functional package manager

First subscribe to the GUIX oai channel (see Chapter Add channel to
system) in
<https://gitlab.kid.local/kidzg/guix-deployment/-/blob/master/DevOps.org>)

Then install using the guix

``` shell
guix package -i python-ammosreader
```

# Usage

There are two scripts, which demonstrate the usage of the ammosreader
package.

## iqdw_reader.py

``` shell
python3 iqdw_reader.py 'path_to_iqdw_file'
```

## pdw_reader.py

``` shell
python3 pdw_reader.py 'path_to_pdw_file'
```

To minimize depencencies of the core package other scripts
(audio_reader, ammos_viewer) are now stored in separate packages.

# Logging

If you use ammosreader in your own scripts a logger can be imported and
used as follows:

``` python
from ammosreader import logger
logger.warning("Put your warning here")
```

## Log-File

The name of the logfile is ammos.log The logger uses the directory
stored in the AMMOS_LOG_DIR environment variable. If this variable is
not set, /tmp is used as default. This might change to *var/log* in
future versions running under GUIX system. If the logfile is not
writable, the standard logger config is used and the logs go directly to
console (tty). (see ammos_logging.conf file in this repository)

## Log-Level

You can change the log-Level by setting the environment variable
AMMOS_LOG_LEVEL. To turn off logging completely set the level to
'CRITICAL'

``` shell
export AMMOS_LOG_LEVEL=CRITICAL
```

If the environment variable does not exist, the logging level from
ammos_logging.conf is used.
