import logging
import logging.config
import os
from pathlib import Path

# change the default log path to /var/log/ammos/ammos.log when system configuration created this dir
# with the appropriate rights

log_dir = Path(os.environ.get('AMMOS_LOG_DIR', '/tmp/'))

log_path = log_dir / 'ammos.log'

if not log_path.exists():
#   print(log_path, "does not exist")
    try:
#       print("Trying to create logfile", str(log_path))
        log_path.touch()
    except PermissionError:
#       print("Logging to file disabled")
        conf_file = Path(__file__).parent / 'ammos_logging.conf'
        print("Conf file", conf_file)
        logging.config.fileConfig(conf_file)
else:
#   print("Logging to", str(log_path))
    logging.basicConfig(filename=str(log_path), encoding='utf-8', level=logging.DEBUG)

logger = logging.getLogger(__name__)

logger.warning("Text")
