import logging
import os
from pathlib import Path

logger = logging.getLogger(__name__)

logging_dir = Path(os.environ.get('AMMOS_LOG_DIR'))

if not log_dir.exists():
    log_dir = Path('/var/log/')
log_path = log_dir / 'ammos.log'

if not log_path.exists():
    print(log_path, "does not exist")
    print("Logging disabled")
    logging.config.fileConfig('ammos_logging.conf')
else:
    logging.basicConfig(filename=str(log_path))
