import pytest
from flowtimer.Phase import Phase


class TestPhase:

    @pytest.fixture
    def phase(self):
        return Phase.default()

    def test_phase_initialization(self, phase):
        assert phase.title == "Default"
        assert phase.initial_ticks == 30
        assert phase.state == "initial"
        assert phase.ticks_left == 30

#    def test_phase_str_representation(self):
#        phase = Phase("Warm-up", 300)
#        expected_str = "-->Warm-up\nInitial=300\n"
#        assert str(phase) == expected_str

    def test_phase_start(self, phase):
        phase.start()
        assert phase.state == "running"
        assert phase.is_running() is True

    def test_phase_pause(self, phase):
        phase.start()
        phase.pause()
        assert phase.state == "paused"
        assert phase.is_paused() is True

    def test_phase_abort(self, phase):
        phase.abort()
        assert phase.state == "aborted"
        assert phase.is_aborted() is True

    def test_phase_tick(self, phase):
        phase.start()
        phase.tick(10)
        assert phase.ticks_left == 20
        assert phase.state == "running"
        assert phase.is_running()

    def test_phase_tick_to_completion(self, phase):
        phase.start()
        phase.tick(30)
        assert phase.ticks_left == 0
        assert phase.is_completed() is True
        assert phase.state == 'completed'

    def test_phase_tick_beyond_completion(self, phase):
        phase.start()
        phase.tick(350)
        assert phase.ticks_left == 0
        assert phase.is_completed() is True
        assert phase.state == 'completed'
