import json


class Phase:

    """
    This class is a representation of a single phase inside a timer
    """

    def __init__(self, title, ticks):
        """
        creates the variables associated with that class

        :type title: string
        :param title: Name of phase

        :type ticks: int
        :param ticks: ticks in seconds
        """

        self.title = title
        self.initial_ticks = ticks
        self.state = "initial"
        self.ticks_left = ticks

    def to_json(self):
        return json.dumps({"title": self.title, "initial_ticks": self.initial_ticks})

    def __str__(self):
        """
        Human readable representation of all attributes

        :return: human readable representation of all attributes
        :rtype: String
        """

        return ("-->" + self.title + "\nTicks left=" +
                str(self.ticks_left) + "\n" + str(self.state) + "\n")

    def abort(self):
        self.state = "finished"

    def start(self):
        self.state = "running"

    def reset(self):
        self.ticks_left = self.initial_ticks
        self.state = "initial"

    def pause(self):
        self.state = "paused"

    def running(self):
        return self.state == "running"
        # return self.time_left > 0

    def finished(self):
        return self.state == "finished"

    def paused(self):
        return self.state == "paused"

    def tick(self, ticks):
        result = self.ticks_left - ticks

        if result <= 0:
            self.ticks_left = 0
            self.state = "finished"
        else:
            self.ticks_left = result
        return result
