import struct
import numpy as np
from AmmosAudioDataHeader import AmmosAudioDataHeader


class AmmosExtendedAudioDataHeader():

    @classmethod
    def from_bytes(cls, bytes):
        standard_header = AmmosAudioDataHeader.from_bytes(bytes[0:36])
        extended_header_elements = struct.unpack('Q', bytes[36:])
        timestamp = extended_header_elements[0]
        sample_rate = standard_header.sample_rate
        status = standard_header.status
        frequency = standard_header.frequency
        demod_bandwidth = standard_header.demod_bandwidth
        demod_type = standard_header.demod_type
        sample_count = standard_header.sample_count
        channel_count = standard_header.channel_count
        sample_size = standard_header.sample_size
        return AmmosExtendedAudioDataHeader(sample_rate, status, frequency, demod_bandwidth, demod_type,
                                            sample_count, channel_count, sample_size, timestamp)

    def __init__(self, sample_rate, status, frequency, demod_bandwidth, demod_type,
                 sample_count, channel_count, sample_size, timestamp):
        self.sample_rate = sample_rate
        self.status = status
        self.frequency = frequency
        self.demod_bandwidth = demod_bandwidth
        self.demod_type = demod_type
        self.sample_count = sample_count
        self.channel_count = channel_count
        self.sample_size = sample_size
        self.timestamp = timestamp
