"""I provide an AMMOS data block for audio data frames."""


class AmmosAudioDataBody:
    """I implement an AMMOS data block for audio data frames."""

    def __init__(self, pcm_data, number_of_channels=1, samples_per_channel=1, sample_size=1):
        """I return a new AMMOS data block for audio data frames."""
        self.__number_of_channels = number_of_channels
        self.__samples_per_channel = samples_per_channel
        self.__sample_size = sample_size
        self.__data = pcm_data

    @property
    def data(self):
        """I return the raw pcm data with channels interweaved."""
        return self.__data

    def pcm_for_channel(self, channel_number):
        """I return the raw pcm data for a given channel."""
        start_offset = channel_number * self.__sample_size
        step = self.__sample_size * self.__number_of_channels
        end = (len(self.__data) // step) * step
        channel_bytes = b""
        for each in range(start_offset, end, step):
            channel_bytes += self.__data[each:each+self.__sample_size]
        return channel_bytes

    def __str__(self):
        """I return the string representation of myself."""
        return ("Number of channels:" + str(self.__number_of_channels) +
                "\nSamples per channel:" + str(self.__samples_per_channel) +
                "\nSample size:" + str(self.__sample_size) +
                "\nData size:" + str(len(self.__data)))
