"""I provide an AMMOS data block for audio data frames."""


class AmmosAudioDataBlock():
    """I implement an AMMOS data block for audio data frames."""

    def __init__(self, audio_datablock_header, audio_data_body):
        """I return a new AMMOS data block for IF data frames."""
        self.__header = audio_datablock_header
        self.__body = audio_data_body

    @property
    def body(self):
        """I return the raw pcm data with channels interweaved."""
        return self.__body
