"""I provide an AMMOS data block for IF data frames."""


class AmmosIFDataBlock():
    """I implement an AMMOS data block for IF data frames."""

    def __init__(self, if_datablock_header, if_data_body):
        """I return a new AMMOS data block for IF data frames."""
        self.__header = if_datablock_header
        self.__body = if_data_body

    @property
    def header(self):
        """I return my data block header."""
        return self.__header

    @property
    def body(self):
        """I return the raw pcm data with channels interweaved."""
        return self.__body
