"""I provide several constants used in R&S software."""

from enum import Enum


class FrameType(int, Enum):
    """I map numbers to human readable format specifiers."""

    TEST_DATA = 0x00
    IF_DATA_32BIT_REAL_IMAGINARY_FIXEDPOINT = 0x01
    IF_DATA_16BIT_REAL_IMAGINARY_FIXEDPOINT = 0x02
    IF_DATA_16BIT_REAL_REAL = 0x03
    IF_DATA_32BIT_REAL_IMAGINARY_FIXEDPOINT_RESCALED = 0x04
    IF_DATA_32BIT_REAL_IMAGINARY_FLOATINGPOINT_RESCALED = 0x05
    SPECTRUM_DATA_8BIT = 0x10
    SPECTRUM_DATA_16BIT = 0x11
    SPECTRUM_DATA_32BIT = 0x12
    SPECTRUM_DATA_32BIT_FLOATINGPOINT = 0x13
    SEGMENTATION_SPECTRUM_DATA_32BIT_FLOATINGPOINT = 0x14
    HF_TUNING_INDICATOR_DATA = 0x20
    HF_SCAN_CHANNEL_FOUND_DATA = 0x22
    HF_SCAN_FREQUENCY_FOUND_DATA = 0x23
    HF_SCAN_SWEEP_RESTARTED_DATA = 0x24
    HF_DEMODULATION_SYMBOL_STREAM_DATA = 0x30
    HF_DECODER_TEXT_DATA = 0x40
    HF_SPECTRUM_VISUALIZATION_DATA = 0x50
    HF_TIMEDOMAIN_VISUALIZATION_DATA = 0x51
    AUDIO_DATA = 0x100
    EMISSION_LIST_DATA = 0x110
    LEVEL_DATA = 0x120
    SYMBOL_DATA = 0x130
    INSTANTANEOUS_DATA = 0x140
    BURST_EMMISION_LIST = 0x150
    IMAGE_DATA = 0x160
    TRANSMISSION_SYSTEM_RESULT_DATA = 0x170
    PULSE_DESCRIPTION_WORD_DATA = 0x200
    PULSE_REPETITION_WORD_DATA = 0x210
    EM050_SCAN_DATA = 0x4000
    SCAN_LEVEL = 0x4001
    SCAN_TUNING = 0x4002
    SCAN_LEVEL_TUNING = 0x4003
    DDF_RESERVED_START = 0x5000
    DDF_RESERVED_END = 0x50FF


class AmmosAudioDemodType(int, Enum):
    """I map numbers to human readable demodulation types."""

    FM = 0
    AM = 1
    ISB = 5
    CW = 6
    USB = 7
    LSB = 8
    DIGITAL = 256
    UNKNOWN = 0xFFFFFFFF
