import json


class Phase:

    """
    This class is a representation of a single phase inside a timer
    """

    def __init__(self, title, ticks):
        """
        creates the variables associated with that class

        :type title: string
        :param title: Name of phase

        :type ticks: int
        :param ticks: ticks in seconds
        """

        self.title = title
        self.initial_ticks = ticks
        self._state = "initial"
        self._ticks_left = ticks

    @property
    def initial_repetitions(self):
        return 1

    @property
    def state(self):
        return self._state

    @property
    def ticks_left(self):
        return self._ticks_left

    def to_json(self):
        return json.dumps({"title": self.title, "initial_ticks": self.initial_ticks})

    def __str__(self):
        """
        Human readable representation of all attributes

        :return: human readable representation of all attributes
        :rtype: String
        """

        return ("Title:" + self.title + "\nTicks left=" +
                str(self._ticks_left) + "\n" + str(self._state) + "\n")

    def is_sequence(self):
        return False

    def abort(self):
        self._state = "aborted"

    def aborted(self):
        return self.state == "aborted"

    def start(self):
        self._state = "running"

    def reset(self):
        self._ticks_left = self.initial_ticks
        self._state = "initial"

    def pause(self):
        self._state = "paused"

    def running(self):
        return self._state == "running"
        # return self.time_left > 0

    def completed(self):
        return self._state == "completed"

    def paused(self):
        return self._state == "paused"

    def tick(self, ticks):
        result = self._ticks_left - ticks

        if result <= 0:
            self._ticks_left = 0
            self._state = "completed"
        else:
            self._ticks_left = result
        return result
