from abc import ABC, abstractmethod
from collections import deque
from ammosreader.AmmosGlobalFrameHeader import AmmosGlobalFrameHeader


class AmmosSource(ABC):
    def __init__(self, source):
        self.__source = source
        self.__name = ""
        self.__timeout = 5

    @property
    def timeout(self):
        return self.__timeout

    @timeout.setter
    def timeout(self, a_timeout):
        self.__timeout = a_timeout

    @property
    def name(self):
        return self.__name

    @name.setter
    def name(self, a_name):
        self.__name = a_name

    @property
    def source(self):
        return self.__source

    @source.setter
    def source(self, a_source):
        self.__source = a_source

    @abstractmethod
    def read_bytes(self, bytes_to_read):
        pass

    def resync(self):
        magic_word_queue = deque(maxlen=4)
        while True:
            try:
                magic_word_queue.append(self.read_bytes(1))
            except TimeoutError:
                result = False
                break
            byte_array = b''.join(magic_word_queue)

            if byte_array.hex() == AmmosGlobalFrameHeader.MAGIC_WORD:
                result = True
                break
        return result
