# Flowtimer

Flowtimer is a customizable Pomodoro timer designed to enhance productivity by breaking work into intervals, typically 25 minutes long, separated by short breaks. It allows you to configure your work and break sessions through a CSV file and includes predefined phases of activity to help you stay focused.

## Features

- **Configurable Sessions:** Define your own work, short break, and long break durations through a CSV file.
- **Predefined Phases:** Start with standard Pomodoro phases or create your own.
- **Simple Interface:** Easy-to-use command-line interface for starting and managing your sessions.
- **Progress Tracking:** Visual feedback on time remaining for each phase.
- **Customizable Cycle:** Choose how many work sessions you want before taking a longer break.

## Getting Started

### Prerequisites

Ensure you have the following installed on your machine:

- Python 3.x

### Installation

1. Clone the repository:
   ```bash
   git clone https://github.com/yourusername/flowtimer.git
   cd flowtimer
   ```

2. Install the required dependencies:
   ```bash
   pip install -r requirements.txt
   ```

### Usage

1. **Create or Modify Configuration:**

   Flowtimer reads its configuration from a CSV file. The file should define the duration of each phase (in minutes) and the order of phases.

   Example `config.csv`:
   ```csv
   phase,duration
   work,25
   short_break,5
   work,25
   short_break,5
   work,25
   long_break,15
   ```

   This configuration represents a standard Pomodoro cycle: three work sessions of 25 minutes each, separated by 5-minute short breaks, and followed by a 15-minute long break.

2. **Run Flowtimer:**
   ```bash
   python flowtimer.py --config config.csv
   ```

   This will start the timer based on the phases and durations specified in the `config.csv` file.

3. **Adjusting Configuration:**
   To change the timings or the order of phases, simply edit the `config.csv` file and rerun the script.

### Default Configuration

If no configuration file is provided, Flowtimer will use the following default settings:

- 25 minutes of work
- 5 minutes of short break
- 4 work sessions before a 15-minute long break

### Command-line Options

- `--config <file>`: Specify a custom CSV configuration file.
- `--start`: Start the Pomodoro timer with the current configuration.
- `--reset`: Reset the timer to default settings.

### Example

```bash
python flowtimer.py --config myconfig.csv
```

This command will start Flowtimer with a custom configuration provided in `myconfig.csv`.

## Contributing

Contributions are welcome! Please submit a pull request or open an issue to discuss any changes or improvements.

### To-Do

- [ ] Add GUI support
- [ ] Integrate sound notifications
- [ ] Add a pause/resume feature

## License

Flowtimer is open-source software licensed under the [MIT License](LICENSE).

## Acknowledgments

Special thanks to the Pomodoro Technique® for inspiring this tool.
