from pathlib import Path

from ammosreader.PDW import PDW
from ammosreader.PPDWContainer import PPDWContainer

class PPDWReader():

    def __init__(self, file_name):

        self.file = Path(file_name)
        assert self.file.is_file()
        self.container = PPDWContainer(self.file.stem)

    def read_all_frames_left(self):
        with self.file.open() as f:
            while True:
                current_bytes = f.read(32)
                if current_bytes == '':
                    print('End of file detected')
                    break
                if len(current_bytes) != 32:
                    print('Can not read all 32 bytes of next PDW')
                    break
                self.container.add(PDW.from_bytes(current_bytes))
