import sys
import io
from pydub import AudioSegment
from pydub.playback import play

from ammosreader.AmmosAudioReader import AmmosAudioReader

if __name__ == '__main__':

    if len(sys.argv) != 2:
        sys.exit()

    file_name = sys.argv[1]

    print("File name:", file_name)

    dat_file = AmmosAudioReader(file_name)

    dat_file.read_all_frames_left()
    print("Sample rate:", dat_file.container.global_frames[0].global_frame_body.data_header.sample_rate)
    print("Container size:", dat_file.container.size())
    print("Frequencies", dat_file.container.frequencies())
    print("Frame types:", dat_file.container.frame_types())
    print("Unique frame sizes", dat_file.container.unique_frame_sizes())
    print("Total frame size:", sum(dat_file.container.frame_sizes()))
    print("Homogenic:", dat_file.container.is_homogenic())
    pcm_data = dat_file.pcm_for_channel(0)
    print("PCM data size total:", len(pcm_data))
    data = AudioSegment.from_raw(io.BytesIO(pcm_data),
                                 sample_width=2,
                                 frame_rate=22050,
                                 channels=1)
    print("Start playing audio")
    play(data)
