class AmmosAudioDataBlock:

    def __init__(self, pcm_data, number_of_channels=1, samples_per_channel=1, sample_size=1):

        self.__number_of_channels = number_of_channels
        self.__samples_per_channel = samples_per_channel
        self.__sample_size = sample_size
        self.__data = pcm_data

    @property
    def data(self):
        return self.__data

    def pcm_for_channel(self, channel_number):
        start_offset = channel_number * self.__sample_size
        step = self.__sample_size * self.__number_of_channels
        end = (len(self.__data) // step) * step
        channel_bytes = b""
        for each in range(start_offset, end, step):
            channel_bytes += self.__data[each:each+self.__sample_size]
        return channel_bytes

    def __str__(self):
        return ("Number of channels:" + str(self.__number_of_channels) +
                "\nSamples per channel:" + str(self.__samples_per_channel) +
                "\nSample size:" + str(self.__sample_size) +
                "\nData size:" + str(len(self.__data)))
