import logging
import logging.config
import os
from pathlib import Path

# FIXME: change the default log path to /var/log/ammos/ammos.log when system configuration created this dir
# with the appropriate rights

log_dir = Path(os.environ.get('AMMOS_LOG_DIR', '/tmp/'))

log_path = log_dir / 'ammos.log'

if not log_path.exists():
    try:
        log_path.touch()
    except PermissionError:
        conf_file = Path(__file__).parent / 'ammos_logging.conf'
        print("Conf file", conf_file)
        logging.config.fileConfig(conf_file)
else:
    logging.basicConfig(filename=str(log_path), encoding='utf-8', level=logging.DEBUG)

logger = logging.getLogger(__name__)
