class Phase:

    """

    This class is a representation of a single phase inside a timer

    """

    def __init__(self, title, duration):

        """

        creates the variables associated with that class

        :type title: string
        :param title: Name of phase

        :type duration: int
        :param duration: Duration in seconds

        """

        self.title = title
        self.duration = duration
        self.state = "initial"
        self.time_left = self.duration


    def __str__(self):

        """

        Human readable representation of all attributes

        :return: human readable representation of all attributes
        :rtype: String

        """

        return ("-->" + self.title + "\nDuration=" +
                str(self.duration) + "\n")

    def abort(self):
        self.state = "finished"

    def start(self):
        self.state = "running"

    def pause(self):
        self.state = "paused"

    def running(self):
        return self.state == "running"
        # return self.time_left > 0

    def finished(self):
        return self.state == "finished"

    def paused(self):
        return self.state == "paused"

    def tick(self, duration):
        self.time_left -= duration

        if self.time_left <= 0:
            self.time_left = 0
            self.state = "finished"
