# Flowtimer

Flowtimer is a customizable Pomodoro timer designed to enhance productivity by breaking work into intervals, typically 25 minutes long, separated by short breaks. It allows you to configure your work and break sessions through a JSON file and includes predefined phases of activity to help you stay focused.

## Features

- **Configurable Sessions:** Define your own work, short break, and long break durations through a JSON file.
- **Predefined Phases:** Start with standard Pomodoro phases or create your own.
- **Progress Tracking:** Visual feedback on time remaining for each phase.
- **Customizable Cycle:** Choose how many work sessions you want before taking a longer break.

## Getting Started

### Prerequisites

Ensure you have the following installed on your machine:

- Python 3.x

### Test without install
   ```bash
   git clone --branch guix https://gitlab.kid.local:/legacy/flowtimer.git
   cd flowtimer

   guix shell python python:tk python-pillow --
   export PYTHONPATH=$PYTHONPATH:./
   python3 flowtimer/main.py
   ```

### Installation

1. Clone the repository:
   ```bash
    git clone --branch guix https://gitlab.kid.local:/legacy/flowtimer.git
	cd flowtimer
   ```
2. Install the app and required dependencies
   ```bash
	pip3 install .

   ```
### Usage

1. **Create or Modify Configuration:**

   Flowtimer reads its configuration from a JSON file.
   
   Example `default.json`:

```json
{
  "title": "Default",
  "blocks": [
    {
      "type": "Phase",
      "title": "MorningHuddle",
      "initial_ticks": 900
    },
    {
      "type": "Sequence",
      "title": "AM",
      "sequence": [
        {
          "title": "Tasking",
          "initial_ticks": 120
        },
        {
          "title": "Working",
          "initial_ticks": 5400
        },
        {
          "title": "Syncing",
          "initial_ticks": 300
        },
        {
          "title": "Break",
          "initial_ticks": 600
        }
      ],
      "initial_repetitions": 2
    },
    {
      "type": "Phase",
      "title": "Lunch",
      "initial_ticks": 2700
    },
    {
      "type": "Sequence",
      "title": "PM",
      "sequence": [
        {
          "title": "Tasking",
          "initial_ticks": 120
        },
        {
          "title": "Working",
          "initial_ticks": 5400
        },
        {
          "title": "Syncing",
          "initial_ticks": 600
        },
        {
          "title": "Break",
          "initial_ticks": 600
        }
      ],
      "initial_repetitions": 2
    }
  ]
}
```

This configuration represents a standard schedule named 'default':

It starts with a 15 min (900s) morning huddle, followed by a sequence 'AM' consisting of 'Tasking', 'Working', 'Syncing', that is repeated twice.
    
After a 45 min lunch break, another sequence 'PM' follows, that is repeated twice as well.

Color schemes can be configured as follows. Use the phase title as title for each color scheme to match them.


```json
{
    "color_schemes": [
	{
	    "title": "Completed",
	    "widget": "red",
	    "sequence_label": "red",
	    "center_frame": "red"
	},
	{
	    "title": "Huddle",
	    "widget": "blue",
	    "sequence_label": "red",
	    "center_frame": "yellow"
	},
	{
	    "title": "Tasking",
	    "widget": "red",
	    "sequence_label": "yellow",
	    "center_frame": "blue"
	},
	{
	    "title": "Work",
	    "widget": "yellow",
	    "sequence_label": "blue",
	    "center_frame": "red"
	},
	{
	    "title": "Break",
	    "widget": "green",
	    "sequence_label": "brown",
	    "center_frame": "white"
	},
	{
	    "title": "Start",
	    "widget": "white",
	    "sequence_label": "green",
	    "center_frame": "brown"
	},
	{
	    "title": "Default",
	    "widget": "pink",
	    "sequence_label": "orange",
	    "center_frame": "violet"
	}
    ]
}
```

2. **Run Flowtimer:**
   ```bash
   python3 flowtimer.py --start --config /path/to/config_file.json
   ```

   This will start the timer based on the phases and durations specified in the JSON file.

3. **Adjusting Configuration:**
   To change the timings or the order of phases, simply edit the JSON file and rerun the script.


### Command-line Options

- `--config <file>`: Specify a custom JSON configuration file.
- `--colors`: Specify a JSON color scheme configuration file.
- `--start`: Autostart the timer with the current configuration.
### Example

```bash
python3 flowtimer.py --config myschedule.json --colors mycolorscheme.json
```

This command will start Flowtimer with a custom configuration provided in `myschedule.json` using color scheme from mycolorscheme.json.

## Contributing

Contributions are welcome! Please submit a pull request or open an issue to discuss any changes or improvements.

## License

Flowtimer is open-source software licensed under the [MIT License](LICENSE).

## Acknowledgments

Special thanks to the Pomodoro Technique® for inspiring this tool.
