from datetime import datetime

class AmmosContainer():

    def __init__(self, name, frames):
        self.name = name
        self.global_frames = frames
        self.tags = []

    def add_tag(self, tag):
        self.tags.append(tag)

    def add_frame(self, frame):
        self.global_frames.append(frame)

    def size(self):
        len(self.global_frames)

    def frequencies(self):
        return set(list(filter(lambda frame: frame.global_frame_body.data_header.frequency, self.global_frames)))

    def __str__(self):
        start_time = self.global_frames[0].global_frame_body.data_header.timestamp
        end_time = self.global_frames[-1].global_frame_body.data_header.timestamp

        frq = str(self.global_frames[0].global_frame_body.data_header.frequency)

        return ("Start time: " + str(start_time) +
                "\nEnd time  : " + str(end_time) + "\nFrequencies: " + frq)
