import pytest
from flowtimer.Phase import Phase

class TestPhase:

    def test_phase_initialization(self):
        phase = Phase("Warm-up", 300)
        assert phase.title == "Warm-up"
        assert phase.initial_ticks == 300
        assert phase.state == "initial"
        assert phase.ticks_left == 300

#    def test_phase_str_representation(self):
#        phase = Phase("Warm-up", 300)
#        expected_str = "-->Warm-up\nInitial=300\n"
#        assert str(phase) == expected_str

    def test_phase_start(self):
        phase = Phase("Warm-up", 300)
        phase.start()
        assert phase.state == "running"
        assert phase.is_running() is True

    def test_phase_pause(self):
        phase = Phase("Warm-up", 300)
        phase.start()
        phase.pause()
        assert phase.state == "paused"
        assert phase.is_paused() is True

    def test_phase_abort(self):
        phase = Phase("Warm-up", 300)
        phase.abort()
        assert phase.state == "aborted"
        assert phase.is_aborted() is True

    def test_phase_tick(self):
        phase = Phase("Warm-up", 300)
        phase.start()
        phase.tick(60)
        assert phase.ticks_left == 240
        assert phase.state == "running"

    def test_phase_tick_to_completion(self):
        phase = Phase("Warm-up", 300)
        phase.start()
        phase.tick(300)
        assert phase.ticks_left == 0
        assert phase.is_completed() is True

    def test_phase_tick_beyond_completion(self):
        phase = Phase("Warm-up", 300)
        phase.start()
        phase.tick(350)
        assert phase.ticks_left == 0
