import sys

from ammosreader.PDW import PDW

def main():

    if len(sys.argv) != 2:
        print("Specify name of .ppdw file")
        sys.exit()

    file_name = sys.argv[1]

    with open(file_name, 'rb') as f:

        while(True):
            current_bytes = f.read(32)
            if current_bytes == '':
                print("End of file detected")
                break
            if len(current_bytes) != 32:
                print("Can not read all 32 bytes of next PDW")
                break

            current_pdw = PDW.from_bytes(current_bytes)
            print(current_pdw)

if __name__ == '__main__':
	main()
