import struct
import numpy

class AmmosAudioDemodType():

    @classmethod
    @property
    def mapping(cls):
        return {0: 'FM', 1: 'AM', 5: 'ISB', 6: 'CW',
                7: 'USB', 8: 'LSB', 256: 'DIGITAL',
                0xFFFFFFFF: 'UNKNOWN'}

    def __init__(self, demod_type):
        self.demod_type = demod_type

    def __str__(self):
        return AmmosAudioDemodType.mapping[self.demod_type]

class AmmosAudioDataHeader():

    @classmethod
    def from_bytes(cls, bytes):
        elements = struct.unpack('<IIQIIIII', bytes)
        sample_rate = elements[0]
        status = elements[1]
        frequency = elements[2]
        demod_bandwidth = elements[3]
        demod_type = elements[4]
        sample_count = elements[5]
        channel_count = elements[6]
        sample_size = elements[7]
        return AmmosAudioDataHeader(sample_rate, status, frequency, demod_bandwidth, demod_type,
                                    sample_count, channel_count, sample_size)

    def __init__(self, sample_rate, status, frequency, demod_bandwidth, demod_type, sample_count, channel_count, sample_size):
        self.sample_rate = sample_rate
        self.status = status
        self.frequency = frequency
        self.demod_bandwidth = demod_bandwidth
        self.demod_type = AmmosAudioDemodType(demod_type)
        self.sample_count = sample_count
        self.channel_count = channel_count
        self.sample_size = sample_size

    def __str__(self):
        return ("\nAmmosAudioDataHeader\n" +
                "Sample rate:" + str(self.sample_rate) + "\n" +
                "Status:" + str(self.status) + "\n" +
                "Frequency:" + str(self.frequency) + "\n" +
                "Demodulation bandwidth:" + str(self.demod_bandwidth) + "\n" +
                "Demodulation type:" + str(self.demod_type) + "\n" +
                "Sample count:" + str(self.sample_count) + "\n" +
                "Channel count:" + str(self.channel_count) + "\n" +
                "Sample size:" + str(self.sample_size) + "\n")
