"""I provide an AMMOS global frame body."""

class AmmosGlobalFrameBody():
    """
    I implement an AMMOS global frame body.

    AMMOS frames can store data of various types.
    The data is described in the data header.
    The raw data is then stored in the data body.
    """
    def __init__(self, data_header, data_body):
        self.__data_header = data_header
        self.__data_body = data_body

    @property
    def data_header(self):
        return self.__data_header

    @data_header.setter
    def data_header(self, a_data_header):
        self.__data_header = a_data_header

    @property
    def data_body(self):
        return self.__data_body

    @data_body.setter
    def data_body(self, data_bytes):
        self.__data_body = data_bytes

    def payload(self):
        """I return the payload only."""
        return b"".join([each_block.data for each_block in self.data_body])
