#!/usr/bin/env python3

import sys
import os

from ammosreader.AmmosIFReader import AmmosIFReader

if __name__ == '__main__':

    if len(sys.argv) != 2:
        sys.exit()

    file_name = sys.argv[1]

    print("File name:", file_name)

    dat_file = AmmosIFReader(file_name)

    dat_file.read_all_frames_left()
    print("Frequencies", dat_file.container.frequencies())
    print("Frame types:", dat_file.container.frame_types())
    print("Frame sizes:", dat_file.container.frame_sizes())
    print("Homogenic:", dat_file.container.is_homogenic())
