Module ammosreader.PDW
======================
I store the information of a single PDW block.

Classes
-------

`PDW(time_of_arrival, pdw_format_identifier, center_frequency, is_valid, is_pulse, level_unit, signal_start_missing, signal_end_missing, pulse_width, frequency_shift_or_bandwidth, pulse_level_or_pulse_field_strength, region_of_interest, azimuth_confidence, modulation, sector, polarity, df_quality, elevation, azimuth, channel)`
:   I store information from a single ppdw data block.
    
    .. automethod:: __init__
    
    I return an instance of an Pulse Data word.
    
    :param time_of_arrival: nanoseconds since 1970-01-01 00:00:00
    :type time_of_arrival: Integer
    :param pdw_format: format code
    :type pdw_format: Integer
    :param center_frequency: center frequency in KHz
    :type center_frequency: Integer
    :param is_valid: flag to mark if pdw data body is valid
    :type is_valid: Boolean
    :param is_pulse: flag to mark if pdw data body contains a pulse or a continuous wave signal
    :type is_pulse: Boolean
    :param level_unit: 0 means dBµV - 1 means dBµV/m
    :type level_unit: Integer
    :param signal_start_missing: signal started before time of arrival
    :type signal_start_missing: Boolean
    :param signal_end_missing: signal stops after time of arrival
    :type signal_end_missing: Boolean
    :param pulse_width: pulse width in nanoseconds - Zero if no valid pulse detected
    :type pulse_width: Integer
    :param frequency_shift_or_bandwidth: Value in KHz - Value set to 1048575 means Unknown
    :type frequency_shift_or_bandwidth: Integer
    :param pulse_level_or_pulse_field_strength: Pulse level or Pulse Field Strength depending on level_unit \
     (-200.0...200.0) in 0.1 steps / minus 204.8 means no valid level detected
    :type pulse_level_or_pulse_field_strength: Float
    :param region_of_interest: Marks if signal is from region of interest
    :type region_of_interest: Boolean
    :param azimuth_confidence: degree in steps of 0.1 (0.0-6.2) / 6.3 means confidence unknown
    :type azimuth_confidence: Float
    :param modulation: type of modulation (e.g. PSK-2, PSK-4, FM etc.)
    :type modulation: String
    :param sector: reference antenna sector (0-15)
    :type sector: Integer
    :param polarity: Horizontal, Vertical, Clockwise, Counter clockwise
    :type polarity: String
    :param df_quality: Direction finding quality in percent (0-100) - Zero means unknown
    :type df_quality: Integer
    :param elevation: elevation of incoming signal (from -90 to 90 degree) in steps of 0.1 degree \
    minus 102.4 means unknown
    :type elevation: Float
    :param azimuth: azimuth of incoming signal (from 0 to 359.9 degree) in steps of 0.1 degree \
    plus 409.5 means unknown
    :type azimuth: Float
    :param channel: detecting channel (0-16) - Zero means unknown
    :type channel: Integer
    :return: An instance of class PDW with attributes set according to the data of a data body
    :rtype: PDW

    ### Static methods

    `from_bytes(byte_string)`
    :   I create an instance of class PDW from data body (8 * 32 bits).
        
        :param byte_string: a byte string containing a single data body read from a ppdw file
        :type byte_string: byte string
        
        :return: an instance of class PDW with attributes set according to the data of a data body
        :rtype: PDW

    ### Methods

    `is_valid(self)`
    :

    `to_json(self)`
    :