Module ammosreader.AbstractAmmosReader
======================================
I provide a base class for specialized AmmosReaders.

Classes
-------

`AbstractAmmosReader(file_name)`
:   I implement a base class for specialized AmmosReaders.
    
    I am the standard constructor for Ammos Readers.
    
    Additional information about the file can be added as key/value pairs in tags
    
    :param file_name: The file to read Ammos data from
    :type file_name: str

    ### Ancestors (in MRO)

    * abc.ABC

    ### Descendants

    * ammosreader.AmmosAudioReader.AmmosAudioReader
    * ammosreader.AmmosIFReader.AmmosIFReader

    ### Instance variables

    `ammos_file`
    :   I return the file to read the data from.

    `container`
    :   I return the container which stores the data read.

    `file_name`
    :   I return the name of the original file.

    `tags`
    :   I return all the tags.

    ### Methods

    `add_tag(self, a_key, a_value)`
    :   I add information to tags using a key/value pair.

    `read_all_frames_left(self)`
    :   I read all remaining frames into my container until end of file is reached.
        
        :return: a container containing all frames read
        :rtype: AmmosContainer

    `read_next_global_frame_body(self, data_header_length)`
    :   My descendents have to implement this.

    `read_next_global_frame_header(self)`
    :   I return the next global frame header read from current position in file.
        
        :return: the next global frame header or None if incomplete
        :rtype: AmmosGlobalFrameHeader

    `read_next_single_frame(self)`
    :   I read and return a single global frame.
        
        :return: a single global frame
        :rtype: AmmosSingleFrame

    `rewind_to_start(self)`
    :   I set the file pointer to the beginning of the file for the next operation.