Module ammosreader.AmmosIFReader
================================
I provide a specialized Ammos Reader for IF data.

Classes
-------

`AmmosIFReader(file_name)`
:   I read the IF data embedded in an R&S AMMOS recording.
    
    I am the standard constructor for Ammos Readers.
    
    Additional information about the file can be added as key/value pairs in tags
    
    :param file_name: The file to read Ammos data from
    :type file_name: str

    ### Ancestors (in MRO)

    * ammosreader.AbstractAmmosReader.AbstractAmmosReader
    * abc.ABC

    ### Methods

    `payload(self)`
    :

    `read_next_global_frame_body(self, data_header_length)`
    :   I return the next global frame body read from current position in file.
        
        :param data_header_length: the length of the data header
        :type data_header_length: int

    `read_next_global_frame_body_data_header(self)`
    :

    `read_next_global_frame_body_extended_data_header(self)`
    :   I return the next global frame body extended data header from current position in file.
        
        :return: the next Ammos Extended IF data header or None if incomplete
        :rtype: AmmosExtendedIFDataHeader

    `read_next_if_data_body(self, number_of_data_blocks, data_length)`
    :   I return the next data body read from current position in file.
        
        :param number_of_data_blocks: the number of data blocks inside the body
        :type number_of_data_blocks: int
        
        :param data_length: the length of the raw data inside a single block
        :type data_length: int