Module ammosreader.AmmosAudioReader
===================================
I provide a specialized Ammos Reader for audio data.

Classes
-------

`AmmosAudioReader(file_name)`
:   I read the audio data embedded in an R&S AMMOS recording.
    
    I return an instance of AmmosAudioReader initialized with a given file name.
    
    :param file_name: the file to read from
    :type file_name: str

    ### Ancestors (in MRO)

    * ammosreader.AbstractAmmosReader.AbstractAmmosReader
    * abc.ABC

    ### Methods

    `pcm_for_channel(self, a_channel)`
    :   I return the raw pcm audio data for a given channel.
        
        :param a_channel: the channel I have to extract
        :type a_channel: int
        
        :rtype: bytes

    `read_next_audio_data_body(self, number_of_samples, number_of_channels, sample_size)`
    :   I return the next audio data read from current position in file.
        
        :param number_of_samples: the number of samples per channel inside data body
        :type number_of_samples: int
        
        :param number_of_channels: number of channels (e.g. mono, stereo or even more)
        :type number_of_channels: int
        
        :param sample_size: sample size in bytes (1, 2 or 4 bytes)
        :type sample_size: int
        
        :return: the next audio data or None if incomplete
        :rtype: bytes

    `read_next_global_frame_body(self, data_header_length)`
    :   I return the next global frame body read from current position in file.
        
        :param data_header_length: the length of the data header
        :type data_header_length: int

    `read_next_global_frame_body_data_header(self)`
    :   I return the next global frame body data header from current position in file.
        
        :param data_header_size: the number of bytes to read
        :type data_header_size: int
        :return: the next Ammos Audio Data header or None if incomplete
        :rtype: AmmosAudioDataHeader

    `read_next_global_frame_body_extended_data_header(self)`
    :   I return the next global frame body extended data header from current position in file.
        
        :return: the next Ammos Audio Extended Data header or None if incomplete
        :rtype: AmmosExtendedAudioDataHeader