class PPDWContainer():
    """
    I store multiple signals imported from one or more .ppdw files
    .. automethod:: __init__
    """

    def __init__(self, name, signals=None):

        if signals is None:
            self.signals = []
        else:
            self.signals = signals

    def __str__(self):
        return "\n".join(["Number of pulses:" + str(len(self.signals)),
                          "Start time:" + str(self.start_time()),
                          "End time:" + str(self.end_time())])

    def add(self, a_pdw):
        self.signals.append(a_pdw)

    def start_time(self):
        return min([each.time_of_arrival for each in self.signals])

    def end_time(self):
        return max([each.time_of_arrival for each in self.signals])

if __name__ == '__main__':
    pass
