class AmmosSingleFrame():

    def __init__(self, global_frame_header, global_frame_body):
        self.__global_frame_header = global_frame_header
        self.__global_frame_body = global_frame_body

    @property
    def global_frame_header(self):
        return self.__global_frame_header

    @property
    def global_frame_body(self):
        return self.__global_frame_body

    def data(self):
        return self.global_frame_body.data_bytes_only()

    def size_correct(self):
        return (self.global_frame_header.frame_length == (24 + self.global_frame_header.data_header_length +
                                                          (self.global_frame_body.data_header.block_count *
                                                           (self.global_frame_body.data_header.block_length + 4))))
    # FIXME: Use str method instead

    def __str__(self):
        output = (
            "Global frame header\n" +
            "-------------------\n" +
            "Frame type:" + str(self.global_frame_header.frame_type) + "\n" +
            "Frame count:" + str(self.global_frame_header.running_frame_number) + "\n" +
            "Data header length:" + str(self.global_frame_header.data_header_length) + " bytes\n" +
            "Frame length:" + str(self.global_frame_header.frame_length) + " bytes\n"
        )
        return output
