"""I store the content of an R&S Ammos file in a more accessible way."""

class AmmosContainer():

    def __init__(self, name, frames):
        self.__name = name
        self.__global_frames = frames
        self.__tags = []

    @property
    def name(self):
        return self.__name

    @name.setter
    def name(self, a_name):
        self.__name = a_name

    @property
    def global_frames(self):
        return self.__global_frames

    def add_tag(self, tag):
        self.__tags.append(tag)

    def add_frame(self, frame):
        self.__global_frames.append(frame)

    def size(self):
        return sum([each.global_frame_header.frame_length for each in self.__global_frames])

    def frequencies(self):
        return set(list(filter(lambda frame: frame.global_frame_body.data_header.frequency, self.__global_frames)))

    def __str__(self):
        start_time = self.__global_frames[0].global_frame_body.data_header.timestamp
        end_time = self.__global_frames[-1].global_frame_body.data_header.timestamp

        frq = str(self.__global_frames[0].global_frame_body.data_header.frequency)

        return ("Start time: " + str(start_time) +
                "\nEnd time  : " + str(end_time) + "\nFrequencies: " + frq)

    def data_only(self):
        return [each.global_frame_body.data_body.data for each in self.__global_frames]
