import sys
import os
sys.path.append('../src/')
import socket

try:
    file_path = sys.argv[1]
except IndexError:
    print("Please provide a file path as argument")
    sys.exit(1)
except FileNotFoundError:
    print("File not found")
    sys.exit(1)

file = open(file_path, 'rb')
total_bytes = file.read()
print('File read')

print('Connecting to socket')
out_socket = socket.socket()
out_socket.setsockopt(socket.SOL_SOCKET, socket.SO_REUSEADDR, 1)
out_socket.setsockopt(socket.SOL_SOCKET, socket.SO_REUSEPORT, 1)
out_socket.connect(('127.0.0.1', 12345))
print('Connected')
print('Sending Bytes')
out_socket.sendall(total_bytes)
