"""
I provide an AMMOS data body for IF data.

I manage multiple IF data blocks
"""

class AmmosIFDataBody:
    """I implement an AMMOS data body for IF data."""
    def __init__(self, data_blocks=None):
        if data_blocks is None:
            self.__data_blocks = []
        else:
            self.__data_blocks = data_blocks

    @property
    def data_blocks(self):
        return self.__data_blocks

    def add_data_block(self, a_data_block):
        self.__data_blocks.append(a_data_block)

    @property
    def data(self):
        b"".join([each.data for each in self.data_blocks])
