import pytest
from flowtimer.Schedule import Schedule
from flowtimer.Phase import Phase

class TestSchedule:
    
    def test_schedule_initialization(self):
        phase1 = Phase("Warm-up", 300)
        phase2 = Phase("Workout", 600)
        schedule = Schedule([phase1, phase2])
    
        assert schedule.phase_list == [phase1, phase2]
        assert schedule.current_phase == phase1
        assert schedule.state == "initial"
        assert schedule.progressbar is None
        assert schedule.currentValue == 0

    def test_schedule_start(self):
        phase1 = Phase("Warm-up", 300)
        schedule = Schedule([phase1])
        schedule.start()
    
        assert schedule.state == "running"
        assert schedule.current_phase.running() is True
    
    def test_schedule_pause(self):
        phase1 = Phase("Warm-up", 300)
        schedule = Schedule([phase1])
        schedule.start()
        schedule.pause()
    
        assert schedule.state == "paused"
        assert schedule.is_paused() is True

    def test_schedule_abort(self):
        phase1 = Phase("Warm-up", 300)
        schedule = Schedule([phase1])
        schedule.start()
        schedule.abort()
    
        assert schedule.state == "finished"
        assert schedule.current_phase.finished() is True

    def test_schedule_finished(self):
        phase1 = Phase("Warm-up", 300)
        phase2 = Phase("Workout", 600)
        schedule = Schedule([phase1, phase2])
    
        assert schedule.finished() is False
    
        phase1.start()
        phase1.tick(300)
        assert phase1.finished() is True
        assert schedule.finished() is False
    
        schedule.skip()
        schedule.current_phase.tick(600)
        assert schedule.finished() is True

    def test_schedule_skip(self):
        phase1 = Phase("Warm-up", 300)
        phase2 = Phase("Workout", 600)
        schedule = Schedule([phase1, phase2])
    
        schedule.start()
        schedule.skip()
    
        assert schedule.current_phase == phase2

    def test_schedule_skip_at_final_phase(self):
        phase1 = Phase("Warm-up", 300)
        schedule = Schedule([phase1])
    
        schedule.start()
        schedule.skip()
    
        assert schedule.state == "finished"

    def test_schedule_tick(self):
        phase1 = Phase("Warm-up", 300)
        phase2 = Phase("Workout", 600)
        schedule = Schedule([phase1, phase2])
    
        schedule.start()
        schedule.tick(300)
    
        assert phase1.finished() is True
        assert schedule.current_phase == phase2
        assert schedule.state == "running"

    def test_schedule_tick_to_completion(self):
        phase1 = Phase("Warm-up", 300)
        phase2 = Phase("Workout", 600)
        schedule = Schedule([phase1, phase2])
    
        schedule.start()
        schedule.tick(300)  # Should finish phase1 and move to phase2
        schedule.tick(600)  # Should finish phase2 and complete the schedule
    
        assert phase2.finished() is True
        assert schedule.finished() is True

    def test_schedule_current_phase_is_final(self):
        phase1 = Phase("Warm-up", 300)
        phase2 = Phase("Workout", 600)
        schedule = Schedule([phase1, phase2])
    
        assert schedule.current_phase_is_final() is False
    
        schedule.skip()
        assert schedule.current_phase_is_final() is True

