import json
from copy import deepcopy
from flowtimer.Phase import Phase


class RecurringPhaseSequence:

    @classmethod
    def from_json(cls, a_json_string):
        def custom_object_hook(d):
            if 'title' in d and 'duration' in d:
                return Phase(d['title'], d['duration'])
            if 'phase_list' in d and 'repetitions' in d:
                return RecurringPhaseSequence(d['phase_list'], d['repetitions'])
            return d
        return json.loads(a_json_string, object_hook=custom_object_hook)

    @classmethod
    def default_json_string(cls):
        return json.dumps({"phase_list": [{"title": "Huddle", "duration": 10},
                                          {"title": "Tasking", "duration": 5},
                                          {"title": "Work", "duration": 45},
                                          {"title": "Break", "duration": 15}],
                           "repetitions": 3})

    def __init__(self, phase_list, repetitions):
        self.phase_list = phase_list
        self.repetitions = repetitions

    def to_json(self):
        return json.dumps(self.__dict__, default=lambda each: each.to_json())

    def unrolled(self):
        return [deepcopy(seq) for seq in [each for each in self.repetitions * self.phase_list]]
        # return self.repetitions * self.phase_list
