"""I provide an Ammos extended data header for audio data frames."""

import struct
from ammosreader.AmmosAudioDataHeader import AmmosAudioDataHeader


class AmmosExtendedAudioDataHeader:

    HEADER_SIZE = 44  # 11 words

    @classmethod
    def from_bytes(cls, bytes):
        """I return a new AMMOS extended data header for audio frames built from given bytes."""
        assert len(bytes) == cls.HEADER_SIZE
        standard_header = AmmosAudioDataHeader.from_bytes(bytes[0:AmmosAudioDataHeader.HEADER_SIZE])
        extended_header_elements = struct.unpack('<Q', bytes[AmmosAudioDataHeader.HEADER_SIZE:])
        timestamp = extended_header_elements[0]
        sample_rate = standard_header.sample_rate
        status = standard_header.status
        frequency = standard_header.frequency
        demod_bandwidth = standard_header.demod_bandwidth
        demod_type = standard_header.demod_type
        number_of_samples = standard_header.number_of_samples
        number_of_channels = standard_header.number_of_channels
        sample_size = standard_header.sample_size
        return AmmosExtendedAudioDataHeader(sample_rate, status, frequency, demod_bandwidth, demod_type,
                                            number_of_samples, number_of_channels, sample_size, timestamp)

    def __init__(self, sample_rate, status, frequency, demod_bandwidth, demod_type,
                 number_of_samples, number_of_channels, sample_size, timestamp):
        """I return a new AMMOS extended data header for audio frames built from given parameters."""
        self.sample_rate = sample_rate
        self.status = status
        self.frequency = frequency
        self.demod_bandwidth = demod_bandwidth
        self.demod_type = demod_type
        self.number_of_samples = number_of_samples
        self.number_of_channels = number_of_channels
        self.sample_size = sample_size
        self.timestamp = timestamp
