import json


class Schedule:

    def __init__(self, phase_list):
        self.phase_list = phase_list
        self.current_phase = phase_list[0]
        self.state = "initial"

    def to_json(self):
        return json.dumps(self.__dict__)

    def start(self):
        self.state = "running"
        self.current_phase.start()

    def pause(self):
        self.state = "paused"

    def running(self):
        return self.state == "running"

    def is_paused(self):
        return self.state == "paused"

    def abort(self):
        self.current_phase.abort()
        self.state = "finished"

    def finished(self):
        if (self.current_phase.finished()) and (self.phase_list[-1] == self.current_phase):
            self.state = "finished"
            return True
        else:
            return False

    def skip(self):
        if self.current_phase_is_final():
            self.abort()
        else:
            index = self.phase_list.index(self.current_phase)
            self.current_phase = self.phase_list[index+1]

    def time_left(self):
        return self.current_phase.time_left + sum([phase.time_left for phase in self.upcoming_phases])

    def upcoming_phases(self):
        index = self.phase_list.index(self.current_phase)
        return self.phase_list[index:]

    def current_phase_is_final(self):
        index = self.phase_list.index(self.current_phase)
        return index == (len(self.phase_list) - 1)

    def tick(self, duration):
        if not self.finished():
            self.current_phase.tick(duration)
            if self.current_phase.finished():
                if self.current_phase_is_final():
                    self.abort()
                else:
                    self.skip()
                    return True
