import tkinter as tk
import tkinter.ttk as ttk
from tkinter import filedialog
from Schedule import Schedule
from Phase import Phase
from PIL import Image, ImageTk
from copy import copy
import pandas as pd
import os
import math
import datetime

now = datetime.datetime.now()
date = now.strftime("%m/%d/%Y")
time = now.strftime("%H:%M:%S")


class TimerApp(tk.Frame):
    
    def __init__(self, parent):
        
        super().__init__(parent)
        self.parent = parent
        self.count = 0
        self.currentValue = 0
        self.default_config = pd.read_csv("default_config.csv", sep=',', header=0,
                         names=('Titel', 'Values'), index_col=False, keep_default_na=False)
        self.photo = ImageTk.PhotoImage(file='flowtimer_startbg_new.png')
        self.show_config = pd.read_csv("default_config.csv", usecols=[0, 1])
        self.config_state = 'default'

        self.build_gui()

    def build_gui(self):

        s = ttk.Style()
        s.theme_use('clam')
        s.configure("orange.Horizontal.TProgressbar", troughcolor='ivory3', bordercolor='black', background='CadetBlue1', lightcolor='white', darkcolor='black')

        self.headline_frame = tk.Frame(self.parent, bg='white')
        self.headline_frame.pack(side='top', fill='both', expand=False)
        self.center_frame = tk.Frame(self.parent, bg='black')
        self.center_frame.pack(side='top', fill='both', expand=True)
        self.button_frame = tk.Frame(root)
        self.button_frame.pack(side='bottom', fill='both', expand=False)

        self.label_headline = tk.Label(self.headline_frame, text=("Hochintensive Intervallarbeit"), bg='white', fg='grey', font="serif 20")
        self.label_headline.pack(side='left', fill='both', expand=True)

        self.label_config = tk.LabelFrame(self.headline_frame, text="config: ", bg='white', font="serif 12")
        self.label_config.pack(side='right', fill='both', expand=False, ipadx=20, padx=20, pady=10)
        
        self.config_button = tk.Button(self.headline_frame, text="change config", font="courier 14", width=20, command=self.change_config)
        self.config_button.pack(side='right', padx=10, pady=10, expand=False)

        self.label_config_text = tk.Label(self.label_config, text=self.show_config, bg='white', font="serif 10", justify='right')
        self.label_config_text.pack()

        self.label_start = tk.Label(self.center_frame, image=self.photo, bg='black')
        self.label_start.pack(side='left', fill='both', expand=True)

        self.label_sequence = tk.Label(self.center_frame)
        self.label_sequence.pack(side='top', fill='both', expand=True)
        
        self.progressbar = ttk.Progressbar(self.center_frame, style="orange.Horizontal.TProgressbar", orient="horizontal",length=600, mode="determinate")
        self.progressbar.pack(side='top')

        self.label_duration = tk.Label(self.center_frame)
        self.label_duration.pack(side='top', fill='both', expand=True)
        
        self.start_timer_button = tk.Button(self.button_frame, text="START", font="courier 14", width=20, command=self.start)
        self.start_timer_button.pack(side='left', fill='both', ipady=20, expand=True)

        self.freeze_button = tk.Button(self.button_frame, text="PLAY/PAUSE", font="courier 14", width=20, command=self.toggle_tick)
        self.freeze_button.pack(side='left', fill='both', ipady=20, expand=True)

        self.skip_button = tk.Button(self.button_frame, text=("SKIP"), font="courier 14", width=20, command=self.skip)
        self.skip_button.pack(side='left', fill='both', ipady=20, expand=True)

        self.quit_button = tk.Button(self.button_frame, text="QUIT", font="courier 14", width=20, command=self.quit_app)
        self.quit_button.pack(side='left', fill='both', ipady=20, expand=True)

        df = self.default_config
        repeat_of_phases = df['Values'][3]

        phase_1 = Phase(title=df['Titel'][0], duration=df['Values'][0])
        phase_2 = Phase(title=df['Titel'][1], duration=df['Values'][1])
        phase_3 = Phase(title=df['Titel'][2], duration=df['Values'][2])

        if repeat_of_phases == 1:
            phase_list = [phase_1, phase_2, phase_3]

        if repeat_of_phases == 2:
            phase_list = [phase_1, phase_2, phase_3, copy(phase_2), copy(phase_3)]

        if repeat_of_phases == 3:
            phase_list = [phase_1, phase_2, phase_3, copy(phase_2), copy(phase_3), copy(phase_2), copy(phase_3)]

        if repeat_of_phases == 4:
            phase_list = [phase_1, phase_2, phase_3, copy(phase_2), copy(phase_3), copy(phase_2), copy(phase_3),
                          copy(phase_2), copy(phase_3)]

        if repeat_of_phases == 5:
            phase_list = [phase_1, phase_2, phase_3, copy(phase_2), copy(phase_3), copy(phase_2), copy(phase_3),
                          copy(phase_2), copy(phase_3), copy(phase_2), copy(phase_3)]

        self.repeats = repeat_of_phases

        self.schedule = Schedule(phase_list)

    def tick(self):
        
        if self.schedule.is_paused():
            return
        self.label_start.pack_forget()
        current_process = self.after(1000, self.tick)
        self.currentValue = self.currentValue + 1

        if self.schedule.state == 'initial':
            self.label_sequence.config(self.start_color(root))
            self.label_sequence.config(text=("\n" + str(self.schedule.current_phase.title) + "..."))
            self.label_duration.config(self.start_color(root))
            self.label_duration.config(text=("noch " + str(math.ceil(self.schedule.current_phase.time_left)) + " Min\n"))
            self.schedule.start()
            self.schedule.tick(1)
        else:
            if self.schedule.running():
                self.progress(self.currentValue)
                self.progressbar.update()
                self.label_sequence.configure(self.start_color(root))
                self.center_frame.config(bg=self.start_color(root))
                self.label_sequence.config(bg=self.random_color(self.label_sequence))
                self.label_duration.config(self.random_color(root))
                self.label_duration.config(text=("noch " + str(math.ceil(self.schedule.current_phase.time_left)) + " Min\n"), bg=self.random_color(self.label_duration))
                if self.schedule.tick(1/60):
                    self.round_counter()
                    
            else:
                self.label_sequence.configure(self.time_out_color(root))
                self.label_sequence.config(text=("\n" + "\nTime over !"), bg="red", fg="white")
                self.label_duration.config(text="", bg="red", fg="white")
                self.progressbar.pack_forget()
                self.center_frame.configure(bg="red")
                self.after_cancel(current_process)
                self.skip_button['state'] = 'disabled'
                self.skip_button.config(fg="ivory3")
                self.freeze_button['state'] = 'disabled'
                self.freeze_button.config(fg="ivory3")
    
    def start(self):
        self.schedule.start()
        self.tick()
        self.start_timer_button['state'] = 'disabled'
        self.start_timer_button.config(fg="ivory3")
        self.config_button.pack_forget()
        
    def skip(self):
        self.schedule.skip()
        self.currentValue = 0
        if self.schedule.state == "running":
            self.round_counter()
    
    def toggle_tick(self):
        if self.schedule.is_paused():
            self.freeze_button.config(relief="raised", fg='black')
            self.label_sequence.config(fg="white")
            self.label_duration.config(fg="white")
            self.schedule.start()
            self.tick()
        else:
            self.schedule.pause()
            self.freeze_button.config(relief="sunken", fg="red")
            self.label_sequence.config(text=("\n" + "\n! timer paused !"), fg="red", bg="black")
            self.label_duration.config(text="", bg="black")
            self.center_frame.config(bg="black")

    def quit_app(self):
        self.parent.destroy()
    
    def random_color(self, widget):
        if self.schedule.current_phase.title == "B-Phase":
            widget.configure(bg="blue")
            self.label_sequence.config(text=("\n" + "Besprechung"))
            self.center_frame.configure(bg="blue")
        if self.schedule.current_phase.title == "I-Phase":
            widget.configure(bg="green")
            self.label_sequence.config(text=("\n" + "Intensivphase"))
            self.center_frame.configure(bg="green")
        if self.schedule.current_phase.title == "S-Phase":
            widget.configure(bg="gold")
            self.label_sequence.config(text=("\n" + "Synchronisation"))
            self.center_frame.configure(bg="gold")
            self.label_sequence.configure(fg="blue")
            self.label_duration.configure(fg="blue")


    def start_color(self, widget):
        self.label_sequence.configure(fg="white", font="times 72")
        self.label_duration.configure(fg="white", font="times 72")
        self.center_frame.configure(bg="blue")
        widget.configure(bg="blue")
    
    def time_out_color(self, widget):
        widget.configure(bg="red")
        
    def progress(self, currentValue):
        self.progressbar["value"] = self.currentValue
        self.progressbar["maximum"] = 60
        if self.currentValue == 60:
            self.currentValue = 0

    def round_counter(self):
        self.count += 1
        if self.count < 3:
            self.currentValue = 0
            self.progress(self.currentValue +1)
            self.progressbar.update()
            self.label_config.config(text="Runde: ")
            self.label_config_text.config(text=("1", "/", self.repeats), fg='blue',font="Times 48")
        if self.count >= 3 and self.count < 5:
            self.label_config_text.config(text=("2", "/", self.repeats), fg='blue',font="Times 48")
        if self.count >= 5 and self.count < 7:
            self.label_config_text.config(text=("3", "/", self.repeats), fg='blue',font="Times 48")
        if self.count >= 7 and self.count < 9:
            self.label_config_text.config(text=("4", "/", self.repeats), fg='blue',font="Times 48")
        if self.count >= 9 and self.count < 11:
            self.label_config_text.config(text=("5", "/", self.repeats), fg='blue',font="Times 48")

    def change_config(self):
        self.config_state = 'user'
        self.config_files = [("all files", "*.csv")]
        self.answer = filedialog.askopenfilename(parent=root,
                                                 initialdir=os.chdir("./configs"),
                                                 title="Please choose a config file:",
                                                 filetypes=self.config_files)
        self.user_config = pd.read_csv(self.answer, sep=',', header=0,
                                       names=('Titel', 'Values'), index_col=False, keep_default_na=False)
        self.choosed_config = pd.read_csv(self.answer, usecols=[0, 1])
        self.df = self.user_config
        self.label_config_text.config(text=self.choosed_config)
        df = self.user_config
        repeat_of_phases = df['Values'][3]

        phase_1 = Phase(title=df['Titel'][0], duration=df['Values'][0])
        phase_2 = Phase(title=df['Titel'][1], duration=df['Values'][1])
        phase_3 = Phase(title=df['Titel'][2], duration=df['Values'][2])

        if repeat_of_phases == 1:
            phase_list = [phase_1, phase_2, phase_3]

        if repeat_of_phases == 2:
            phase_list = [phase_1, phase_2, phase_3, copy(phase_2), copy(phase_3)]

        if repeat_of_phases == 3:
            phase_list = [phase_1, phase_2, phase_3, copy(phase_2), copy(phase_3), copy(phase_2), copy(phase_3)]

        if repeat_of_phases == 4:
            phase_list = [phase_1, phase_2, phase_3, copy(phase_2), copy(phase_3), copy(phase_2), copy(phase_3),
                          copy(phase_2), copy(phase_3)]

        if repeat_of_phases == 5:
            phase_list = [phase_1, phase_2, phase_3, copy(phase_2), copy(phase_3), copy(phase_2), copy(phase_3),
                          copy(phase_2), copy(phase_3), copy(phase_2), copy(phase_3)]

        self.repeats = repeat_of_phases

        self.schedule = Schedule(phase_list)

root = tk.Tk()


root.title("--=> flowtimer <=-- " + "  date: " + date + "  time: " + time)
root.geometry("1280x860")
root.config(bg='black')
root.iconphoto(False, ImageTk.PhotoImage(Image.open('icon_bombtimer.png')))

app = TimerApp(root)

app.mainloop()
