import sys
import re
import sqlite3
import argparse
import numpy as np
from datetime import datetime
from pathlib import Path
from pymongo import MongoClient
from ammosreader.AmmosIFReader import AmmosIFReader
from ammosreader.PPDWReader import PPDWReader

parser = argparse.ArgumentParser()
parser.add_argument('-s', '--source', required=True, help='specify source for given signal')
parser.add_argument('-i', '--input-dir', required=True, help='specify source directory')
parser.add_argument('-o', '--output-file', required=True, help='specify sqlite3 database file')
parser.add_argument('-n', '--signal-number', required=True, help='specify number for signal')
parser.add_argument('-c', '--code', required=True, help='specify code for signal')

args = parser.parse_args()

source = args.source.upper()
code = args.code.upper()
signal_number = args.signal_number
input_dir = Path(args.input_dir)
sqlite3_file = Path(args.output_file)

if not re.match('[A-Z0-9]{2}', source):
    print("Source identifier", source, "invalid")
    sys.exit()

if not re.match('[A-Z][0-9]{3}[A-Z]', code):
    print("ELINT-Code incorrect")
    sys.exit(1)

if not re.match('[0-9]{4}', signal_number):
    print("Signal number incorrect")
    sys.exit(1)

if not input_dir.is_dir():
    print("Input dir invalid")
    sys.exit(1)

dir_name = input_dir.name

files_inside = [each for each in (input_dir.iterdir()) if (each.suffix in ['.idx', '.iqdw', '.ppdw'] and each.stem == dir_name)]

if len(files_inside) != 3:
    print(".idx, .iqdw or .ppdw file missing in", input_dir)
    sys.exit(1)

iqdw_file = (input_dir / input_dir.stem).with_suffix('.iqdw')
ppdw_file = (input_dir / input_dir.stem).with_suffix('.ppdw')
idx_file = (input_dir / input_dir.stem).with_suffix('.idx')

#if not sqlite3_file.is_file():
#    print("Sqlite3 database file not found at", sqlite3_file)
#    sys.exit(1)

# try:
#    connection = sqlite3.connect(str(sqlite3_file))
#    cursor = connection.cursor()
# except Exception:
#    print("Can not connect to database file", str(sqlite3_file))
     # sys.exit(1)

#ammos_if_reader = AmmosIFReader(str(iqdw_file))
#ammos_if_reader.read_all_frames_left()
# for each_frame in ammos_if_reader.container.global_frames:
#    print(each_frame)

ppdw_reader = PPDWReader(ppdw_file)
ppdw_reader.read_all_frames_left()

client = MongoClient('hackathon.kid.local', 27017)

database = client['ELINT']
ts = (ppdw_reader.container.start_time() - np.datetime64('1970-01-01T00:00:00')) / np.timedelta64(1, 's')
time_tuple = datetime.utcfromtimestamp(ts).timetuple()
julian_date_string = str(time_tuple.tm_year)[2:] + str(time_tuple.tm_yday).zfill(3)
code_collection = database[code]
year_collection = code_collection[str(time_tuple.tm_year)]
source_collection = year_collection[source]

json_representation = ppdw_reader.container.to_json()
json_representation['SIGNALNUMBER'] = signal_number
json_representation['SOURCEFILE'] = str(ppdw_file)
source_collection.insert_one(json_representation)

# for each in ppdw_reader.container.signals:
#    each_json = each.to_json()
#    each_json['SIGNALNUMBER'] = signal_number
#    each_json['JULIANDATE'] = julian_date_string
#    each_json['SOURCEFILE'] = str(ppdw_file)
#    source_collection.insert_one(each_json)
