from pathlib import Path

from ammosreader.PDW import PDW
from ammosreader.PPDWContainer import PPDWContainer

class PPDWReader():

    def __init__(self, a_file):

        self.file = a_file
        assert self.file.is_file()
        self.content = self.file.read_bytes()
        self.cursor = 0
        self.container = PPDWContainer(self.file.stem)

    def read_all_frames_left(self):
        try:
            while self.cursor <= len(self.content) - 32:
                current_bytes = self.content[self.cursor:self.cursor+32]
                assert len(current_bytes) == 32
                if not current_bytes:
                    # print('End of file detected')
                    break
                if self.cursor + 32 >= len(self.content):
                    # print('Can not read all 32 bytes of next PDW')
                    break
                self.container.add(PDW.from_bytes(current_bytes))
                self.cursor += 32
        except Exception:
            return None
        return self.container
