import tkinter as tk
from tkinter import ttk


class SelectPanel(ttk.Frame):

    # FIXME: Parent should not be used, but event bus, mediator or announcer work better to decouple views
    def __init__(self, parent):
        super().__init__(parent, padding=5)

        frame_left = ttk.Frame(parent)
        frame_left.grid(row=0, column=0, sticky="nsew", padx=5, pady=5)
        frame_left.rowconfigure(1, weight=1)
        frame_left.columnconfigure(0, weight=1)
        frame_left.grid_propagate(True)

        ttk.Label(frame_left, text="Questions").grid(
            row=0, column=0, sticky="w", pady=(0, 5)
        )

        # Listbox + Scrollbar frame
        list_frame = ttk.Frame(frame_left)
        list_frame.grid(row=1, column=0, sticky="nsew")
        list_frame.columnconfigure(0, weight=1)
        list_frame.rowconfigure(0, weight=1)

        # --- Treeview replacing Listbox ---
        parent.question_tree = ttk.Treeview(
            list_frame,
            columns=("text", "state"),
            show="headings",
            selectmode="browse",
        )
        parent.question_tree.heading("text", text="Question")
        parent.question_tree.heading("state", text="State")
        parent.question_tree.column("text", anchor="w", width=500)
        parent.question_tree.column("state", anchor="center", width=100)
        parent.question_tree.grid(row=0, column=0, sticky="nsew")

        # Attach scrollbars

        vscrollbar = ttk.Scrollbar(list_frame, orient="vertical",
                                   command=parent.question_tree.yview)
        vscrollbar.grid(row=0, column=1, sticky="ns")

        hscrollbar = ttk.Scrollbar(list_frame, orient="horizontal",
                                   command=parent.question_tree.xview)
        hscrollbar.grid(row=1, column=0, sticky="ew")

        parent.question_tree.configure(yscrollcommand=vscrollbar.set,
                                       xscrollcommand=hscrollbar.set)

        # Bind events (similar to Listbox)
        parent.question_tree.bind("<<TreeviewSelect>>", parent.on_select_question)
        parent.question_tree.bind("<Double-Button-1>", lambda e: parent.edit_selected_question())
        parent.question_tree.tag_configure("cut", foreground="gray60", font=("", 10, "italic"))
        # Create catalog switcher
        frm_catalog = ttk.Frame(frame_left)
        frm_catalog.grid(row=0, column=0, sticky="ew", pady=(4, 8))
        frm_catalog.columnconfigure(1, weight=1)  # allow dropdown to expand horizontally

        # ─ Label ─
        lbl_catalog = ttk.Label(frm_catalog, text="Catalog:")
        lbl_catalog.grid(row=0, column=0, sticky="w", padx=(0, 6))
        parent.catalog_var = tk.StringVar()
        parent.catalog_dropdown = ttk.Combobox(
            frm_catalog,
            textvariable=parent.catalog_var,
            values=parent.catalog_manager.list_titles(),
            state="readonly",
        )
        parent.catalog_dropdown.bind("<<ComboboxSelected>>", parent.on_catalog_selected)
        parent.catalog_dropdown.grid(row=0, column=1, sticky="ew", pady=(0, 5))

