import tkinter as tk
from tkinter import ttk


class AppMenu(tk.Menu):

    # FIXME: Parent should not be used, but event bus, mediator or announcer work better to decouple views
    def __init__(self, parent):
        super().__init__(parent)

        filemenu = tk.Menu(self, tearoff=0)
        filemenu.add_command(label="Import from exam", command=parent.import_exam)
        filemenu.add_separator()
        filemenu.add_command(label="Exit", command=parent.quit)
        self.add_cascade(label="File", menu=filemenu)

        catalog_menu = tk.Menu(self, tearoff=0)
        catalog_menu.add_command(label="Create Catalog", command=parent.create_catalog)
        catalog_menu.add_command(label="Open Catalog", command=parent.open_catalog)
        self.add_cascade(label="Catalogs", menu=catalog_menu)

        domain_menu = tk.Menu(self, tearoff=0)
        domain_menu.add_command(label="Add domain", command=parent.add_domain)
        self.add_cascade(label="Domains", menu=domain_menu)

        exam_menu = tk.Menu(self, tearoff=0)
        exam_menu.add_command(label="Create new exam", command=parent.create_exam_dialog)
        exam_menu.add_command(label="Layout existing exam", command=parent.layout_exam)
        exam_menu.add_command(label="Load existing exam", command=parent.load_exam)
        self.add_cascade(label="Exams", menu=exam_menu)

        help_menu = tk.Menu(self, tearoff=0)
        help_menu.add_command(label="Help / FAQ", command=parent.show_help)
        self.add_cascade(label="Help", menu=help_menu)
        parent.config(menu=self)

