class Announcer:
    """I am a lightweight event dispatcher similar to Smalltalk's Announcer."""
    def __init__(self):
        self._subscribers = {}

    def when(self, event_name: str, handler):
        """I subscribe a callable to an event name."""
        self._subscribers.setdefault(event_name, []).append(handler)

    def announce(self, event_name: str, **payload):
        """I fire an event with optional keyword data."""
        for handler in self._subscribers.get(event_name, []):
            handler(**payload)
