from tkinter import ttk


class ActionsPanel(ttk.Frame):

    def __init__(self, parent):
        super().__init__(parent, padding=5)

        # Bottom button frame
        frame_buttons = ttk.Frame(parent)
        frame_buttons.grid(row=2, column=0, sticky="ew", pady=(5, 0))

        # Define 6 columns: Add+Type, Copy, Cut, Paste, Delete, Add-to-exam
        for i in range(6):
            frame_buttons.columnconfigure(i, weight=1)

        frame_buttons.columnconfigure(0, weight=2)  # Add + Type (wider)
        frame_buttons.columnconfigure(5, weight=2)  # Add-to-exam area (wider)

        # --- Add + Type ---
        add_frame = ttk.Frame(frame_buttons)
        add_frame.grid(row=0, column=0, sticky="ew", padx=2)
        add_frame.columnconfigure(0, weight=0)
        add_frame.columnconfigure(1, weight=1)

        ttk.Button(add_frame, text="Add", command=parent.add_question).grid(
            row=0, column=0, padx=(4, 6)
        )
        self.qtype_dropdown = ttk.Combobox(
            add_frame,
            textvariable=parent.current_qtype_var,
            values=["instruction", "text", "single_choice", "multiple_choice"],
            state="readonly",
            width=16,
        )
        self.qtype_dropdown.grid(row=0, column=1, sticky="ew")

        # --- Copy / Cut / Paste / Delete ---
        ttk.Button(frame_buttons, text="Copy",
                   command=parent.copy_selected_question).grid(row=0,
                                                               column=1,
                                                               padx=2,
                                                               sticky="ew")
        ttk.Button(frame_buttons, text="Paste",
                   command=parent.paste_selected_question).grid(row=0,
                                                                column=3,
                                                                padx=2,
                                                                sticky="ew")
        ttk.Button(frame_buttons, text="Delete",
                   command=parent.delete_selected_question).grid(row=0,
                                                                 column=4,
                                                                 padx=2,
                                                                 sticky="ew")

        # --- Add to exam + Dropdown ---
        exam_frame = ttk.Frame(frame_buttons)
        exam_frame.grid(row=0, column=5, sticky="ew", padx=(12, 6))
        exam_frame.columnconfigure(0, weight=0)
        exam_frame.columnconfigure(1, weight=1)

        ttk.Button(exam_frame, text="Add to exam",
                   command=parent.add_selected_question_to_exam).grid(row=0, column=0, padx=(0, 4))
        parent.target_exam_dropdown = ttk.Combobox(
            exam_frame,
            textvariable=parent.target_exam_var,
            values=[],
            state="readonly",
            width=18,
        )
        parent.target_exam_dropdown.grid(row=0, column=1, sticky="ew")
        parent.target_exam_dropdown.bind("<<ComboboxSelected>>", parent.on_exam_selected)
