from dataclasses import dataclass
from flexoentity import FlexoEntity, EntityType


@dataclass
class Domain(FlexoEntity):
    """
    I am a helper class to provide more information than just a
    domain abbreviation in FlexOID, doing mapping and management
    """

    ENTITY_TYPE = EntityType.DOMAIN

    fullname: str = ""
    description: str = ""
    classification: str = "UNCLASSIFIED"

    @classmethod
    def default(cls):
        """Return the default domain object."""
        return cls.with_domain_id(domain_id="GEN_GENERIC",
                                  fullname="Generic Domain", classification="UNCLASSIFIED")

    @property
    def text_seed(self) -> str:
        return self.domain_id

    def _deserialize_content(self, content: dict):
        self.fullname = content.get("fullname", "")
        self.description = content.get("description", "")
        self.classification = content.get("classification", "UNCLASSIFIED")

    def _serialize_content(self):
        return {
            "fullname": self.fullname,
            "description": self.description,
            "classification": self.classification,
        }

    @classmethod
    def from_dict(cls, data):

        obj = super().from_dict(data)
        content = data.get("content", {})
        obj._deserialize_content(content)
        return obj
