class PersistanceBackend:
    """
    Interface for all persistence backends.

    Stores serialized FlexOEntity dicts with a flexo_id key.
    """

    def __init__(self, entity_class):
        self._entity_class = entity_class

    @property
    def entity_class(self):
        return self._entity_class

    @entity_class.setter
    def entity_class(self, a_class):
        self._entity_class = a_class

    def save(self, flexo_entity) -> None:
        raise NotImplementedError

    def update(self, flexo_entity) -> None:
        raise NotImplementedError

    def delete(self, flexo_id: str) -> None:
        raise NotImplementedError

    def load(self, flexo_id: str) -> dict | None:
        raise NotImplementedError

    def load_all(self) -> list[dict]:
        raise NotImplementedError

    def clear(self):
        """Remove all stored entities."""
        raise NotImplementedError
