import pytest
from flexoentity import Domain, DomainManager, DuplicateDomainError


# ---------------------------------------------------------------
# Setup/Teardown (clear DomainManager between tests)
# ---------------------------------------------------------------


@pytest.fixture(autouse=True)
def clear_domain_manager(sample_domain_manager):
    sample_domain_manager.clear()


# ---------------------------------------------------------------
# Domain creation + registration
# ---------------------------------------------------------------
def test_domain_registration(sample_domain_manager, sample_domain):

    sample_domain_manager.add(sample_domain)
    # Manager must know it now
    assert sample_domain_manager.get("PY_ARITHM") is sample_domain


# ---------------------------------------------------------------
# Uniqueness: registering the same code twice must fail
# ---------------------------------------------------------------
def test_domain_uniqueness_enforced(sample_domain, sample_domain_manager):

    sample_domain_manager.add(sample_domain)
    with pytest.raises(DuplicateDomainError):
        sample_domain_manager.add(sample_domain)


# ---------------------------------------------------------------
# Lookup by FlexOID
# ---------------------------------------------------------------
def test_lookup_by_oid(sample_domain, sample_domain_manager):
    sample_domain_manager.add(sample_domain)
    found = sample_domain_manager.get(sample_domain.domain_id)
    assert found is sample_domain


# ---------------------------------------------------------------
# JSON roundtrip should preserve identity and not regenerate FlexOID
# ---------------------------------------------------------------
def test_domain_json_roundtrip(sample_domain):
    sample_data = sample_domain.to_dict()
    loaded = Domain.from_dict(sample_data)

    # Same exact instance
    assert loaded == sample_domain

    # Same FlexOID
    assert str(loaded.flexo_id) == str(sample_domain.flexo_id)

