@dataclass
class Domain(FlexoEntity):
    abbrev: str
    fullname: str
    description: str = ""
    classification: str = "UNCLASSIFIED"
    owner: str = "unknown"

    @property
    def qtype(self):  # or entity_type
        return EntityType.DOMAIN

    def to_dict(self):
        base = super().to_dict()
        base.update({
            "abbrev": self.abbrev,
            "fullname": self.fullname,
            "description": self.description,
            "classification": self.classification,
            "owner": self.owner
        })
        return base
